#include <amxmodx>
#include <sqlx>
#include <reapi>


stock const VERSION[] = "1.0.1beta";

	/* Параметры по типу микроконстант */
#define TASK_FIX_MYSQL 120230221019
#define TASK_FIX_MODEL 120230223302

	/* Создаем переменные для SQL. */
new Handle:sth;

	/* Различные настройки */
new server_id;
new user_model_t[33][33];
new user_model_ct[33][33];

	/* База купленных товаров (по индексу сервера) */
enum _:DATA_PURCHASES { NICK_NAME[33], MODEL_NAME_T[64], MODEL_NAME_CT[64], PASS_WORD[64], SKIN_ID };
new Array:i_ArrayPurchases, i_Purchases[DATA_PURCHASES];

public plugin_precache() {
	new buffer[512], precache_t[256], precache_ct[256], str[64];
	new file = fopen("/addons/amxmodx/configs/gamecms_skins.ini", "rt");
	if(!file) {
		set_fail_state("File not found!");
	}
	while(!feof(file)) {
		fgets(file, buffer, charsmax(buffer));
		trim(buffer);

		if(!buffer[0] || buffer[0] == ';')
			continue;
		if(parse(buffer, precache_t, charsmax(precache_t), precache_ct, charsmax(precache_ct)) == 2) {
			formatex(str, charsmax(str), "models/player/%s/%s.mdl", precache_t, precache_t);
			if(file_exists(str)) {
				precache_model(str);
			} else	log_amx("[WARNING] Model '%s' not found.", str);

			formatex(str, charsmax(str), "models/player/%s/%s.mdl", precache_ct, precache_ct);
			if(file_exists(str)) {
				precache_model(str);
			} else	log_amx("[WARNING] Model '%s' not found.", str);
		}
	}

	fclose(file);
}

public plugin_init() {
	register_plugin("GameCMS Skins", VERSION, "OverGame & game-by.ru");

	RegisterHookChain(RG_CBasePlayer_Spawn, "CBasePlayer_Spawn", true);

	register_cvar("gamecms_hostname", "");
	register_cvar("gamecms_username", "");
	register_cvar("gamecms_password", "");
	register_cvar("gamecms_database", "");
}

public plugin_cfg() {
	new configs_dir[64];
	get_localinfo("amxx_configsdir", configs_dir, charsmax(configs_dir));
	server_cmd("exec %s/gamecms_skins.cfg", configs_dir);
	
	set_task(1.0, "please_connect_mysql", TASK_FIX_MYSQL);
}

public please_connect_mysql(task) {
	new err, error[256];
	sth = SQL_MakeDbTuple(cvar_string("gamecms_hostname"), cvar_string("gamecms_username"), cvar_string("gamecms_password"), cvar_string("gamecms_database"));
	sth = SQL_Connect(sth, err, error, charsmax(error));
	
	if(sth == Empty_Handle) {
		set_fail_state(error);
	}
	
	SQL_QueryAndIgnore(sth, "set names utf8");
	
	new Handle:query;
	
		/* Получаем ID сервера. */
	new address[23];
	get_user_ip(0, address, charsmax(address), 0);
	
	query = f_query(sth, "SELECT * FROM `servers` WHERE `address`='%s'", address);
	server_id = SQL_ReadResult(query, SQL_FieldNameToNum(query, "id"));
	
		/* Получаем покупки пользователей */
	i_ArrayPurchases = ArrayCreate(DATA_PURCHASES);
	query = f_query(sth, "SELECT * FROM `skins__purchases` WHERE `enable`='1' and `server_id`='%d'", server_id);
	
	while(SQL_MoreResults(query)) {
		SQL_ReadResult(query, SQL_FieldNameToNum(query, "nickname"), i_Purchases[NICK_NAME], charsmax(i_Purchases[NICK_NAME]));
		SQL_ReadResult(query, SQL_FieldNameToNum(query, "password"), i_Purchases[PASS_WORD], charsmax(i_Purchases[PASS_WORD]));
		SQL_ReadResult(query, SQL_FieldNameToNum(query, "model_name_t"), i_Purchases[MODEL_NAME_T], charsmax(i_Purchases[MODEL_NAME_T]));
		SQL_ReadResult(query, SQL_FieldNameToNum(query, "model_name_ct"), i_Purchases[MODEL_NAME_CT], charsmax(i_Purchases[MODEL_NAME_CT]));
		i_Purchases[SKIN_ID] = SQL_ReadResult(query, SQL_FieldNameToNum(query, "skin_id"));
		ArrayPushArray(i_ArrayPurchases, i_Purchases);
		
		SQL_NextRow(query);
	}
	
	SQL_FreeHandle(sth);
	remove_task(task);
}

public client_putinserver(id) {
	formatex(user_model_t[id], charsmax(user_model_t[]), "");
	formatex(user_model_ct[id], charsmax(user_model_ct[]), "");
	new  password[33], steam[35];
	get_user_authid(id, steam, charsmax(steam));
	get_user_info(id, cvar_string("amx_password_field"), password, charsmax(password));
	
	for(new i; i < ArraySize(i_ArrayPurchases); i++) {
		ArrayGetArray(i_ArrayPurchases, i, i_Purchases);
		
		if(equal(steam, i_Purchases[NICK_NAME]) && equal(password, i_Purchases[PASS_WORD])) {
			copy(user_model_t[id], charsmax(user_model_t[]), i_Purchases[MODEL_NAME_T]);
			copy(user_model_ct[id], charsmax(user_model_ct[]), i_Purchases[MODEL_NAME_CT]);
			break;
		}
	}
}

public client_disconnected(id) {
	remove_task(TASK_FIX_MODEL + id);
}

public CBasePlayer_Spawn(const id) {
	new TeamName:iTeam = get_member(id, m_iTeam)
	if(is_user_connected(id)){
		if(!equal(user_model_t[id], "") && !equal(user_model_ct[id], "")) {
			set_task(0.2, "set_player_model", TASK_FIX_MODEL + id);
		} 
		//Если хотите добавить модели по флагу то код ниже
		//Модели добавьте в прекешь как и остальные
		/*else if(get_user_flags(id) & ADMIN_LEVEL_B) {
			if(is_user_alive(id) && iTeam == TEAM_TERRORIST) {
				rg_set_user_model(id, "НАЗВАНИЕ ПОДЕЛИ ДЛЯ ТТ");
			} else if(is_user_alive(id) && iTeam == TEAM_CT) {
				rg_set_user_model(id, "НАЗВАНИЕ ПОДЕЛИ ДЛЯ СТ" );
			}
		} else if(get_user_flags(id) & ADMIN_BAN) {
			if(is_user_alive(id) && iTeam == TEAM_TERRORIST) {
				rg_set_user_model(id, "НАЗВАНИЕ ПОДЕЛИ ДЛЯ ТТ");
			} else if(is_user_alive(id) && iTeam == TEAM_CT) {
				rg_set_user_model(id, "НАЗВАНИЕ ПОДЕЛИ ДЛЯ СТ" );
			}
		} else if(get_user_flags(id) & ADMIN_LEVEL_H) {
			if(is_user_alive(id) && iTeam == TEAM_TERRORIST) {
				rg_set_user_model(id, "НАЗВАНИЕ ПОДЕЛИ ДЛЯ ТТ");
			} else if(is_user_alive(id) && iTeam == TEAM_CT) {
				rg_set_user_model(id, "НАЗВАНИЕ ПОДЕЛИ ДЛЯ СТ" );
			}
		}*/
	}
}

public set_player_model(user_id) {
	user_id = user_id - TASK_FIX_MODEL;
	new TeamName:iTeam = get_member(user_id, m_iTeam)
	
	if(is_user_alive(user_id) && iTeam == TEAM_TERRORIST) {
		rg_set_user_model(user_id, user_model_t[user_id]);
	} else if(is_user_alive(user_id) && iTeam == TEAM_CT) {
		rg_set_user_model(user_id, user_model_ct[user_id]);
	}
}

stock Handle:f_query(Handle:connect, const text[], any:...) {
	new request[256];
	vformat(request, charsmax(request), text, 3);
	
	new Handle:query = SQL_PrepareQuery(connect, request);
	
	if(!SQL_Execute(query)) {
		new error[256];
		SQL_QueryError(query, error, charsmax(error));
		
		set_fail_state(error);
	}
	
	return query;
}

stock cvar_string(const cvar_name[]) {
	new text[128];
	get_cvar_string(cvar_name, text, charsmax(text));
	
	return text;
}